% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_postprodn_fns.R
\name{logLik.angmcmc}
\alias{logLik.angmcmc}
\title{Extract Log-Likelihood from angmcmc objects}
\usage{
\method{logLik}{angmcmc}(object, fn = mean, burnin = 1/3, thin = 1, ...)
}
\arguments{
\item{object}{angular MCMC object.}

\item{fn}{function to evaluate on MCMC samples to estimate parameters.  Defaults to \code{mean}, which computes the estimated posterior mean. Used for parameter estimatation.}

\item{burnin}{initial fraction of the MCMC samples to be discarded as burn-in. Must be a value in [0, 1). Used for parameter estimatation.}

\item{thin}{positive integer. If \code{thin =} \eqn{n}, only every \eqn{n}-th realizations of the Markov chain is kept. Used for parameter estimatation.}

\item{...}{some methods for this generic function require additional
   arguments.}
}
\value{
Returns an object of class \link{logLik}. This is a number (the estimated log likelihood) with attributes "df"
(degrees of freedom) and "nobs" (number of observations).
}
\description{
Extract Log-Likelihood from angmcmc objects
}
\details{
In order to estimate the log likelihood for the model, first the parameter vector is estimated using \link{pointest},
and then log the likelihood is calculated on the basis of the estimated parameter.

The degrees of the likelihood function is the total number of free parameters estimated in the mixture models,
which is equal to \eqn{6K - 1} for bivariate models (vmsin, vmcos and wnorm2), or \eqn{3K - 1} for univariate
models (vm and wnorm), where \eqn{K} denotes the number of components in the mixture model.
}
\examples{
# illustration only - more iterations needed for convergence
fit.vmsin.20 <- fit_vmsinmix(tim8, ncomp = 3, n.iter =  20,
                             ncores = 1)
logLik(fit.vmsin.20)
}

