% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_model_select.R
\name{bestmodel}
\alias{bestmodel}
\title{Extracting angmcmc object corresponding to the best fitted model in stepwise fits}
\usage{
bestmodel(step_object)
}
\arguments{
\item{step_object}{stepwise fitted object (output of \code{\link{fit_stepwise_univariate}}
or \code{\link{fit_stepwise_bivariate}}).}
}
\value{
Returns an angmcmc object corresponding to the the best fitted model in step_object.
}
\description{
Extracting angmcmc object corresponding to the best fitted model in stepwise fits
}
\examples{
# illustration only - more iterations needed for convergence
fit.vmsin.step.15 <- fit_stepwise_bivariate(tim8, "vmsin", start_ncomp = 3,
                                            max_ncomp = 5, n.iter = 15,
                                            ncores = 1)
fit.vmsin.best.15 <- bestmodel(fit.vmsin.step.15)
fit.vmsin.best.15

}
