% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_postprodn_fns.R
\name{extractsamples}
\alias{extractsamples}
\title{Extract MCMC samples for parameters from an angmcmc object}
\usage{
extractsamples(object, par.name = NULL, comp.label = NULL,
               burnin = 1/3, thin = 1)
}
\arguments{
\item{object}{angular MCMC object}

\item{par.name}{vector of names of parameters for which point estimates are to be computed.  If \code{NULL}, results for all parameters are provided.}

\item{comp.label}{vector of component labels (positive integers, e.g., \code{1, 2, ...}) for which point estimates are to be computed.
If \code{NULL}, results for all components are provided.}

\item{burnin}{initial fraction of the MCMC samples to be discarded as burn-in. Must be a value in [0, 1).}

\item{thin}{positive integer. If \code{thin =} \eqn{n}, only every \eqn{n}-th realizations of the Markov chain is kept.}
}
\value{
Returns a  matrix (vector) if one (both) of \code{par.name} and \code{comp.label} is of length 1, and a three dimensional array with
third dimension corresponding to iterations if both \code{par.name} and \code{comp.label} have length \code{>1}.
}
\description{
Extract MCMC samples for parameters from an angmcmc object
}
\details{
The default for both \code{par.name} and \code{comp.label} are the all possible choices
available in \code{object}.
}
\examples{
# first fit a vmsin mixture model
# illustration only - more iterations needed for convergence
fit.vmsin.20 <- fit_vmsinmix(tim8, ncomp = 3, n.iter =  20,
                             ncores = 1)
# extract Markov chain realizations for kappa1 from component 1
extr_kappa1_1 <- extractsamples(fit.vmsin.20, "kappa1", 1)
# for kappa1 from component from all components
extr_kappa1 <- extractsamples(fit.vmsin.20, "kappa1")
# for all parameters in component 1
extr_1 <- extractsamples(fit.vmsin.20, comp.label = 1)

}
