% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_postprodn_fns.R
\name{d_fitted}
\alias{d_fitted}
\alias{r_fitted}
\title{Density and random deviates from an angmcmc object}
\usage{
d_fitted(x, object, fn = mean, log = FALSE, ...)

r_fitted(n = 1, object, fn = mean, ...)
}
\arguments{
\item{x}{vector, if univariate or a two column matrix, if bivariate, with each row a 2-D vector, (can
also be a data frame of similar dimensions) of points where the
densities are to be computed.}

\item{object}{angular MCMC object. The dimension of the model must match with \code{x}.}

\item{fn}{function, or a single character string specifying its name, to evaluate on MCMC samples to estimate
parameters.  Defaults to \code{mean}, which computes the estimated posterior mean.
Note that if \code{fn = "MODE"} (warning: not \code{"mode"}) or \code{fn = "MAP"}, then the maximum aposteriori estimate (MAP) is
calculated.}

\item{log}{logical. Should the log density be returned instead?}

\item{...}{additional arguments to be passed to the function.}

\item{n}{number of observations to be generated.}
}
\value{
\code{d_fitted} gives a vector the densities computed at the given points  and \code{r_fitted}
creates a vector (if univariate) or a matrix (if bivariate) with each row being a 2-D point, of random deviates.
}
\description{
Density and random deviates from an angmcmc object
}
\details{
To estimate the mixture density, first the parameter vector \eqn{\eta} is estimated
by applying \code{fn} on the MCMC samples (using the function \link{pointest}), yielding the (consistent) Bayes estimate \eqn{\hat{\eta}}. Then the mixture density
\eqn{f(x|\eta)} at any point \eqn{x} is (consistently) estimated by \eqn{f(x|\hat{\eta})}.

The random deviates are generated from the estimated mixture density \eqn{f(x|\hat{\eta})}.
}
\examples{
set.seed(1)
# illustration only - more iterations needed for convergence
fit.vmsin.20 <- fit_vmsinmix(tim8, ncomp = 3, n.iter =  20,
                             n.chains = 1)
d_fitted(c(0,0), fit.vmsin.20)
r_fitted(10, fit.vmsin.20)
}
