% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_mixmodel.R
\name{fit_angmix}
\alias{fit_angmix}
\title{Fitting Bivariate and univariate angular mixture models}
\usage{
fit_angmix(
  model = "vmsin",
  data,
  ncomp,
  cov.restrict = "NONE",
  unimodal.component = FALSE,
  start_par = NULL,
  rand_start = rep(FALSE, n.chains),
  method = "hmc",
  perm_sampling = FALSE,
  n.chains = 3,
  chains_parallel = TRUE,
  return_llik_contri = FALSE,
  int.displ = 3,
  epsilon = 0.1,
  L = 10,
  epsilon.random = TRUE,
  L.random = FALSE,
  burnin.prop = 0.5,
  tune.prop = 1,
  thin = 1,
  propscale = 0.05,
  n.iter = 500,
  pmix.alpha = NULL,
  norm.var = 1000,
  autotune = TRUE,
  show.progress = TRUE,
  accpt.prob.upper,
  accpt.prob.lower,
  epsilon.incr = 0.05,
  L.incr = 0.075,
  tune.incr = 0.05,
  tune_ave_size = 100,
  kappa_upper = 150,
  kappa_lower = 1e-04,
  return_tune_param = FALSE,
  qrnd = NULL,
  n_qrnd = NULL,
  ...
)
}
\arguments{
\item{model}{angular model whose mixtures are to be fitted. Available choices are \code{"vmsin", "vmcos"} and \code{"wnorm2"} for
bivariate data, and \code{"vm"} and \code{"wnorm"} for univariate data.}

\item{data}{data matrix (if bivarate, in which case it must have two columns) or vector. If outside, the values
are transformed into the scale \eqn{[0, 2\pi)}. *Note:* BAMBI cannot handle missing data. Missing values must
either be removed or properly imputed.}

\item{ncomp}{number of components in the mixture model. Must be a positive integer. vector values are not allowed.
If \code{comp == 1}, a single component model is fitted.}

\item{cov.restrict}{Should there be any restriction on the covariance parameter for a bivariate model. Available choices are
\code{"POSITIVE", "NEGATIVE", "ZERO"} and "NONE". Note that \code{"ZERO"} fits a mixture with product components. Defaults to
\code{"NONE"}.}

\item{unimodal.component}{logical. Should each component in the mixture model be unimodal? Only used if \code{model} is either \code{"vmsin"}
or \code{"vmcos"}. Defaults to FALSE.}

\item{start_par}{list with elements \code{pmix} (ignored if \code{comp == 1}), together with \code{kappa1, kappa2, mu1} and \code{mu2},
for bivariate models, and \code{kappa} and \code{mu} for univariate models,
all being vectors of length same as \code{ncomp}.
These provides the starting values for the Markov chain; with \eqn{j}-th component of each vector corresponding to the \eqn{j}-th
component of the mixture distribution. If missing, the data is first clustered into \code{ncomp} groups either via k-means (after
projecting onto a unit sphere), or randomly, depending on \code{rand_start},  and then moment estimators for components are used as
the starting points. Note that a very wrong starting point can potentially lead the chain to get stuck at a wrong solution for thousands
of iterations. As such, we recommend using the default option, which is k-means followed by moment estimation.}

\item{rand_start}{logical. Should a random starting clustering be used? Must be either a scalar, or a vector of length \code{ncomp},
one for each chain. Ignored if \code{start_par} is supplied. See \code{start_par} for more details. Defaults to \code{FALSE}.}

\item{method}{MCMC strategy to be used for the model paramters:  \code{"hmc"} or \code{"rwmh"}.}

\item{perm_sampling}{logical. Should the permutation sampling algorithm of Fruhwirth-Schnatter (2001) be used?
If TRUE, at every iteration after burnin, once model parameters and mixing proportions are sampled,
a random permutation of 1, ..., ncomp is considered, and components are relabelled according
to this random permutation. This forced random label switchings may imporve the mixing rate of the chage. However, (automated) tuning
is very difficult with such a scheme, as there is no simple way of keeping track of the "original" component labels. This creates problem
with computing standard deviations of the generated model parameters, thus making the
scaling step used in tuning for \code{epsilon} or \code{paramscale} problematic as well. As such, \code{perm_sampling} is always turned
off during burn-in (even if \code{autotune = FALSE}), and turned on thereafter, if \code{TRUE}.
Defaults to and is set to \code{FALSE}.}

\item{n.chains}{number of chains to run. Must be a positive integer.}

\item{chains_parallel}{logical. Should the chains be run in parallel? Defaluts to TRUE, and ignored if \code{n.chains} = 1.
Note that parallelization is implemented via \link{future_lapply} from package \code{future.apply} which
uses futures for this purpose, and thus provides a convenient way of parallelization across various OSs and computing environments.
However, a proper \link[future]{plan} must be set for the parallization before running the chain. Otherwise the chains will run sequentially.}

\item{return_llik_contri}{logical. Should the log likelihood contribution of each data point for each MCMC iteration in each chain be returned? This makes
computation of \link{waic.angmcmc} and \link{loo.angmcmc} much faster. *Warning*: Depending on the length of data and \code{n.iter}, this can be
very memory intensive. We suggest setting \code{return_llik_contri = TRUE} only if \link{waic.angmcmc} and \link{loo.angmcmc} are aimed for. Defaults to
\code{FALSE}.}

\item{int.displ}{absolute integer displacement for each coordinate for \code{wnorm} and \code{wnorm2} models (ignored otherwise). Default is 3.
Allowed minimum and maximum are 1 and 5 respectively.}

\item{epsilon, L}{tuning parameters for HMC; ignored if \code{method = "rwmh"}. \code{epsilon} (step-size) is a single number,
or a vector of size \code{2*ncomp} for univariate models and \code{5*ncomp} for bivariate models. Note that the "mass matrix"
in HMC is assumed to be identity. As such, \code{epsilon}'s corresponding to different model parameters need to be in proper scale for
optimal acceptance rate. Can be autotuned during burnin. See \code{autotune}.
\code{L} (leapfrog steps) is a positive integer or a vector of positive integers of length \code{n.chains}.
If multiple chains are used, we suggest same \code{L} values acorss different chains to make the chains as homogenous as possible.}

\item{epsilon.random}{logical. Should \code{epsilon*delta}, where \code{delta} is a random
number between \code{(1-epsilon.incr, 1+epsilon.incr)} be used instead of \code{epsilon} at each iteration?
Ignored if \code{method = "rwmh"}.}

\item{L.random}{logical. Should a random integer between \code{L.orig/exp(L.incr)} and \code{L.orig*exp(L.incr)}be used instead as \code{L}
at each iteration? Ignored if \code{method = "rwmh"}. Defaults to \code{TRUE}.}

\item{burnin.prop}{proportion of iterations to used for burnin. Must be a be a number in [0, 1].
Default is 0.5.}

\item{tune.prop}{proportion of *\code{burnin}* used to tune the parameters (\code{epsilon} in HMC and
\code{propscale} in RWMH). Must be a number between 0 and 1; defaults to 1.  Ignored if \code{autotune == FALSE}.}

\item{thin}{thining size to be used. Must be a positive integer. If \code{thin = } n, then every nth iteration is reatained
in the final MCMC sample.}

\item{propscale}{tuning parameters for RWMH; a vector of size 5 (for bivariate models) or 2 (for univariate models) representing
the variances for the proposal normal densities
for the model parameters. Ignored if \code{method = "hmc"}. Can be autotuned during burnin. See \code{autotune}.}

\item{n.iter}{number of iterations for the Markov Chain.}

\item{pmix.alpha}{concentration parameter(s) for the Dirichlet prior for \code{pmix}. Must either be a positive real number, or a vector
with positive entries and of length \code{ncomp}. The default is \eqn{(r+r(r+1)/2)/2+3}, where \eqn{r} is 1 or 2 according as whether
the model is univariate or bivariate. Note that it is recommended to use larger \code{alpha} values to ensure the a good posterior behavior,
especially when \link{fit_incremental_angmix} is used for model selection, which handles overfitting in "let two component-specific parameters be
size, and then penalizes for model complexity. See Fruhwirth-Schnatter (2011) for more details on this.}

\item{norm.var}{variance (hyper-) parameters in the normal prior for \code{log(kappa), log(kappa1), log(kappa2)} and \code{kappa3}. (Prior mean is zero).
Can be a vector. Default is 1000 that makes the prior non-informative.}

\item{autotune}{logical. Should the Markov chain auto-tune the parameter \code{epsilon} (in HMC) or
\code{propscale} (in RWMH) during burn-in?  Set to \code{TRUE} by default. An adaptive tuning strategy is implemented.
Here, at every 10th iteration during in burn-in, the acceptance ratio in the last \code{tune_ave_size}
iterations is calculated. Then the tuning parameter is decreased  (increased) by a factor of
\code{1-tune.incr} (\code{1+tune.incr}) if the calculated acceptance rate
falls below (above) \code{accpt.prob.lower} (\code{accpt.prob.upper}). In addditon, when \code{iter} is a multiple of
\code{tune_ave_size}, \code{epsilon} for each model parameter is rescaled via the standard deviation of
the corresponding parameter over the past \code{tune_ave_size} iterations.}

\item{show.progress}{logical. Should a progress bar be displayed?}

\item{accpt.prob.lower, accpt.prob.upper}{lower and upper limits of acceptance ratio to be maintained while tuning
during burn-in. Must be numbers between 0 and 1, which \code{accpt.prob.lower < accpt.prob.upper}. See \code{autotune}. Default to (0.6, 0,9) for HMC and  (0.3, 0.5) for RWMH.
Ignored if \code{autotune = FALSE}.}

\item{epsilon.incr}{amount of randomness incorporated in \code{epsilon} if \code{epsilon.random = TRUE}.}

\item{L.incr}{amount of randomness incorporated in L if \code{L.random = TRUE}.}

\item{tune.incr}{how much should the tuning parameter be increased or decreased at each step while tuning during burn-in?
Must be a number between 0 and 1. See \code{autotune}. Defaults to 0.05. Ignored if \code{autotune = FALSE}.}

\item{tune_ave_size}{number previous iterations used to compute the acceptance rate while tuning in burn-in. Must be a positive
integer. Defaults to 100.}

\item{kappa_upper, kappa_lower}{upper and lower bounds for the concentration and (absolute) association parameters. Must be a positive integers. Defaults to 150 and 1e-4,
and parameter with value above or below these limits rarely make sense in practice.
Warning: values much larger or smaller than the default are not recommended as they can cause numerical instability.}

\item{return_tune_param}{logical. Should the values of the tuning parameters used at each iteration in each chain be returned? Defaults to \code{FALSE}.}

\item{qrnd, n_qrnd}{Used only if \code{method="vmcos"}. See \link{dvmcos} for details.}

\item{...}{Unused.}
}
\description{
Fitting Bivariate and univariate angular mixture models
}
\note{
Sampling is done in log scale for the concentration parameters (kappa, kappa1 and kappa2).


Parallelization is done by default when more than one chain is used,
but the chains can be run sequentially as well by setting
\code{chains_parallel = FALSE}. To retain reproducibility while running
multiple chains in parallel, the same RNG state is passed at the
beginning of each chain. This is done by specifying \code{future.seed = TRUE}
in \code{future.apply::future_lapply} call. Then at the beginning of the i-th
chain, before drawing any parameters, i-many Uniform(0, 1) random numbers are
generated using \code{runif(i)} (and then thrown away). This ensures that the
RNG states across chains prior to random generation of the parameters are
different, and hence, no two chains can become identical, even if they have
the same starting and tuning parameters. This, however creates a difference
between a \code{fit_angmix} call with multiple chains which is run sequentially
by setting \code{chains_parallel = FALSE}, and another which is run sequentially
because of a sequential \code{plan()} (or no \code{plan()}), with
\code{chains_parallel = TRUE}. In the former, different RNG states are passed at
the initiation of each chain.
}
\examples{
# illustration only - more iterations needed for convergence
fit.vmsin.20 <- fit_angmix("vmsin", tim8,
  ncomp = 3, n.iter = 20,
  n.chains = 1
)
fit.vmsin.20


# Parallelization is implemented via future_lapply from the
# package future.apply. To parallelize, first provide a parallel
# plan(); otherwise the chains will run sequentially.
# Note that not all plan() might work on every OS, as they execute
# functions defined internally in fit_mixmodel. We suggest
# plan(multisession) which works on every OS.
\donttest{
library(future)
library(parallel)
# plan(multisession, gc = TRUE) # parallelize chains

set.seed(1)
MC.fit <- fit_angmix("vmsin", tim8,
  ncomp = 3, n.iter = 5000,
  n.chains = 3
)


pointest(MC.fit)

MC.fix <- fix_label(MC.fit)

contour(MC.fit)
contour(MC.fix)
lpdtrace(MC.fit)
}

}
\references{
Fruhwirth-Schnatter, S. (2011). Label switching under model uncertainty. Mixtures: Estimation and Application, 213-239.

Fruhwirth-Schnatter, S. (2001). Markov chain Monte Carlo estimation of classical and dynamic switching and mixture models. Journal of the American Statistical Association, 96(453), 194-209.
}
