% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/web_scraping.R
\name{get_events_detail}
\alias{get_events_detail}
\title{Scrape the details of advertised events in Bath for each day}
\usage{
get_events_detail(from, to)
}
\arguments{
\item{from}{A date or date-time object, or string, of the first
date for which to find events.}

\item{to}{A date or date-time object, or string, of the last
date for which to find events.}
}
\value{
A data frame of daily event details for each day in the specified
 range of months.
}
\description{
Web scraping function to retrieve the detail for events advertised at
 \url{http://www.bath.co.uk/events} for each day in a specified range of
 dates.
}
\examples{
# Return event details for 01 January 2015
events <- get_events_detail("2015-01-01", "2015-01-01")
\dontrun{
# Return daily event details from 01 Oct 2014 to 08 Oct 2014
events <- get_events_detail("2014-10-01", "2014-10-08")
}
}
\seealso{
\code{\link{get_events}}
}
\author{
Ryan Kenning (@rkenning)
}
