% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{update.bas}
\alias{update.bas}
\alias{update}
\title{Update BAS object using a new prior}
\usage{
\method{update}{bas}(object, newprior, alpha = NULL, ...)
}
\arguments{
\item{object}{BMA object to update}

\item{newprior}{Update posterior model probabilities, probne0, shrinkage,
logmarg, etc, using prior based on newprior.  See \code{\link{bas}} for
available methods}

\item{alpha}{optional new value of hyperparameter in prior for method}

\item{...}{optional arguments}
}
\value{
A new object of class BMA
}
\description{
Update a BMA object using a new prior distribution on the coefficients.
}
\details{
Recomputes the marginal likelihoods for the new methods for models already
sampled in current object.
}
\examples{

\donttest{
library(MASS)
data(UScrime)
UScrime[,-2] <- log(UScrime[,-2])
crime.bic <-  bas.lm(y ~ ., data=UScrime, n.models=2^10, prior="BIC",initprobs= "eplogp")
crime.ebg <- update(crime.bic, newprior="EB-global")
crime.zs <- update(crime.bic, newprior="ZS-null")
}

}
\references{
Clyde, M. Ghosh, J. and Littman, M. (2010) Bayesian Adaptive
Sampling for Variable Selection and Model Averaging. Journal of
Computational Graphics and Statistics.  20:80-101 \cr
\doi{10.1198/jcgs.2010.09049}
}
\seealso{
\code{\link{bas}} for available methods and choices of alpha

Other bas methods: 
\code{\link{BAS}},
\code{\link{bas.lm}()},
\code{\link{coef.bas}()},
\code{\link{confint.coef.bas}()},
\code{\link{confint.pred.bas}()},
\code{\link{diagnostics}()},
\code{\link{fitted.bas}()},
\code{\link{force.heredity.bas}()},
\code{\link{image.bas}()},
\code{\link{plot.confint.bas}()},
\code{\link{predict.bas}()},
\code{\link{predict.basglm}()},
\code{\link{summary.bas}()},
\code{\link{variable.names.pred.bas}()}
}
\author{
Merlise Clyde \email{clyde@stat.duke.edu}
}
\concept{bas methods}
\keyword{regression}
