% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{beta.volumes}
\alias{beta.volumes}
\title{Beta diversity partitioning using functional hypervolumes.}
\usage{
beta.volumes(hvlist, n = 10000)
}
\arguments{
\item{hvlist}{a list of hypervolumes (one for each species or community), constructed with the hypervolume package.}

\item{n}{number of points to be considered for the estimation algorithm (10000 at least, but better 100000).}
}
\value{
A list with all relevant statistics including pairwise replacement and net difference in ampitude components of hypervolumes.
}
\description{
Pairwise beta diversity partitioning into replacement and net difference in ampitude components of hypervolumes.
}
\details{
Computes a pairwise decomposition of the overall differentiation among hypervolumes into two components:
the replacement (shifts) of space between hypervolumes and net differences between the amount of space enclosed by each hypervolume.
}
\references{
Carvalho, J.C. & Cardoso, P. (2018). Decomposing the causes for niche and functional differentiation between species and communities using hypervolumes. Submitted.
}
