% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{kernel.originality}
\alias{kernel.originality}
\title{Functional originality of species or individuals in a kernel density hypervolume representing a given community.}
\usage{
kernel.originality(
  comm,
  trait,
  method = "box",
  abund = FALSE,
  frac = 0.1,
  relative = FALSE
)
}
\arguments{
\item{comm}{A hypervolume object constructed with the hypervolume R package or a sites x species matrix, with incidence or abundance data about the species in the community. Note that HypervolumeList is not implemented for this function yet.}

\item{trait}{A matrix of traits for each species in comm (a species for each row and traits as columns). Must be provided only if 'comm' is a sites x species matrix.}

\item{method}{Method for constructing the hypervolume. One of "box" (box kernel density estimation), "gaussian" (Gaussian kernel density estimation), or "svm" (one-class support vector machine). See respective functions of the hypervolume package for details. Must be provided only if 'comm' is a sites x species matrix.}

\item{abund}{A boolean (T/F) indicating whether abundance data should be used or converted to incidence before analysis. If not specified, default is FALSE. Ignored if a Hypervolume is provided as input data.}

\item{frac}{A value between 0.01 and 1, indicating the fraction of random points to be used in the estimation of originality. Default is 0.1.}

\item{relative}{A boolean (T/F) indicating whether originality should be relative to the most original species.}
}
\value{
A matrix with the originality values of each species or individual in each site.
}
\description{
Average dissimilarity between a species or individual and a sample of random points within the boundaries of the hypervolume.
}
\details{
Increase frac for less deviation in the estimation.
}
\examples{
comm <- rbind(c(0,3,2,1), c(1,5,6,2), c(0,0,2,1))
rownames(comm) = c("Community_1","Community_2","Community_3")
colnames(comm) = c("Sp_1","Sp_2","Sp_3","Sp_4")

trait <- cbind(c(2.2,4.4,6.1,8.3),c(0.5,1,0.5,0.4),c(0.7,1.2,0.5,0.4))
rownames(trait) = c("Sp_1","Sp_2","Sp_3","Sp_4")
colnames(trait) = c("Trait_1","Trait_2","Trait_3")

#Example with community and trait matrices as input data 
#kernel.originality(comm = comm, trait = trait, method='gaussian', abund = TRUE, frac = 0.01)

#Example with hypervolume as input data
#kernel.originality(comm = hypervolume_box(trait))
}
\references{
Mammola, S., & Cardoso, P. (Submitted). New functions for calculating functional diversity metrics using kernel density n-dimensional hypervolumes.
}
