% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{optim.beta}
\alias{optim.beta}
\title{Optimization of beta diversity sampling protocols.}
\usage{
optim.beta(comm, tree, methods, base, abund = TRUE, runs = 1000, prog = TRUE)
}
\arguments{
\item{comm}{A samples x species x sites array, with either abundance or incidence data.}

\item{tree}{An hclust or phylo object (used only to optimize PD or FD sampling).}

\item{methods}{A vector specifying the method of each sample (length must be equal to nrow(comm))}

\item{base}{Allows defining a base mandatory protocol from which to build upon (complementarity analysis). It should be a vector with length = number of methods.}

\item{abund}{A boolean (T/F) indicating whether abundance data should be used or converted to incidence before analysis.}

\item{runs}{Number of random permutations to be made to the sample order. Default is 1000.}

\item{prog}{Present a text progress bar in the R console.}
}
\value{
A matrix of samples x methods (values being optimum number of samples per method). The last column is the average absolute difference from real beta.
}
\description{
Optimization of beta diversity sampling protocols when different methods and multiple samples per method are available.
}
\details{
Often, comparing differences between sites or the same site along time (i.e. measure beta diversity) it is not necessary to sample exhaustively. A minimum combination of samples targeting different sub-communities (that may behave differently) may be enough to perceive such differences, for example, for monitoring purposes.
Cardoso et al. (in prep.) introduce and differentiate the concepts of alpha-sampling and beta-sampling. While alpha-sampling optimization implies maximizing local diversity sampled (Cardoso 2009), beta-sampling optimization implies minimizing differences in beta diversity values between partially and completely sampled communities.
This function uses as beta diversity measures the Btotal, Brepl and Brich partitioning framework (Carvalho et al. 2012) and respective generalizations to PD and FD (Cardoso et al. 2014).
PD and FD are calculated based on a tree (hclust or phylo object, no need to be ultrametric).
}
\examples{
comm1 <- matrix(c(1,1,0,2,4,0,0,1,2,0,0,3), nrow = 4, ncol = 3, byrow = TRUE)
comm2 <- matrix(c(2,2,0,3,1,0,0,0,5,0,0,2), nrow = 4, ncol = 3, byrow = TRUE)
comm3 <- matrix(c(2,0,0,3,1,0,0,0,5,0,0,2), nrow = 4, ncol = 3, byrow = TRUE)
comm <- array(c(comm1, comm2, comm3), c(4,3,3))
colnames(comm) <- c("sp1","sp2","sp3")
methods <- c("Met1","Met2","Met2","Met3")
tree <- hclust(dist(c(1:3), method="euclidean"), method="average")
optim.beta(comm, methods = methods, runs = 100)
optim.beta(comm, tree, methods = methods, abund = FALSE, base = c(0,0,1), runs = 100)
}
\references{
Cardoso, P. (2009) Standardization and optimization of arthropod inventories - the case of Iberian spiders. Biodiversity and Conservation, 18, 3949-3962.

Cardoso, P., Rigal, F., Carvalho, J.C., Fortelius, M., Borges, P.A.V., Podani, J. & Schmera, D. (2014) Partitioning taxon, phylogenetic and functional beta diversity into replacement and richness difference components. Journal of Biogeography, 41, 749-761.

Cardoso, P., et al. (in prep.) Optimal inventorying and monitoring of taxon, phylogenetic and functional diversity.

Carvalho, J.C., Cardoso, P. & Gomes, P. (2012) Determining the relative roles of species replacement and species richness differences in generating beta-diversity patterns. Global Ecology and Biogeography, 21, 760-771.
}
