% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{uniqueness}
\alias{uniqueness}
\title{Phylogenetic/functional uniqueness of species.}
\usage{
uniqueness(comm, tree, distance, relative = TRUE)
}
\arguments{
\item{comm}{A sites x species matrix, with either abundance or incidence data. If missing, the uniqueness using the full tree or distance matrix is calculated.}

\item{tree}{A phylo or hclust object (used only for PD or FD) or alternatively a species x traits matrix or data.frame to build a functional tree.}

\item{distance}{A dist object representing the phylogenetic or functional distance between species.}

\item{relative}{A boolean (T/F) indicating whether uniqueness should be relative to the maximum distance between any two species in the tree or distance matrix.}
}
\value{
A matrix of sites x species values.
}
\description{
Dissimilarity between each species and the single closest in a community.
}
\details{
This is equivalent to the originality measure of Mouillot et al. (2013).
}
\examples{
comm <- matrix(c(1,2,0,0,0,1,1,0,0,0,0,2,2,0,0,0,0,1,1,1), nrow = 4, byrow = TRUE)
distance <- dist(c(1:5), method="euclidean")
tree <- hclust(distance, method="average")
uniqueness(tree = tree)
uniqueness(distance = distance)
uniqueness(comm, tree)
}
\references{
Mouillot, D., Graham, N.A., Villeger, S., Mason, N.W. & Bellwood, D.R. (2013) A functional approach reveals community responses to disturbances. Trends in Ecology and Evolution, 28: 167-177.
}
