% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_stats_per_period.R
\name{do_stats_per_period}
\alias{do_stats_per_period}
\title{Compute stats per period}
\usage{
do_stats_per_period(data, day_num, game_code, team_sel, period_sel, player_sel)
}
\arguments{
\item{data}{Prepared data from a given game.}

\item{day_num}{Day number.}

\item{game_code}{Game code.}

\item{team_sel}{One of the teams' names involved in the game.}

\item{period_sel}{Period of interest. Options can be "xC", where x=1,2,3,4.}

\item{player_sel}{Player of interest.}
}
\value{
Data frame with one row and mainly time played (seconds and minutes) and points
scored by the player of interest in the period of interest.
}
\description{
Compute time played and points scored for a player of interest in any period
of the game.
}
\note{
The \strong{game_code} column allows us to detect the source website, for example,
\url{https://jv.acb.com/es/103389/jugadas}.
}
\examples{
library(dplyr)
df0 <- acb_vbc_cz_pbp_2223

day_num <- unique(acb_vbc_cz_pbp_2223$day)
game_code <- unique(acb_vbc_cz_pbp_2223$game_code)

# Remove overtimes:
rm_overtime <- TRUE
if (rm_overtime) {
 df0 <- df0 \%>\%
   filter(!grepl("PR", period)) \%>\%
   mutate(period = as.character(period))
}
 
team_sel <- "Valencia Basket" # "Casademont Zaragoza"
period_sel <- "1C"            # "4C"
player_sel <- "Webb"          # "Mara"
 
df1 <- df0 \%>\%
  filter(team == team_sel) \%>\%
  filter(!action \%in\% c("D - Descalificante - No TL", "Altercado no TL")) 
   
df2 <- df1 \%>\%
  filter(period == period_sel)
   
df0_inli_team <- acb_vbc_cz_sl_2223 \%>\% 
   filter(team == team_sel, period == period_sel)
 
df3 <- do_prepare_data(df2, day_num, 
                       df0_inli_team, acb_games_2223_info,
                       game_code)
                        
df4 <- do_stats_per_period(df3, day_num, game_code, team_sel, period_sel, player_sel)
#df4

}
\author{
Guillermo Vinue
}
