% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BETS.sidra.get.R
\name{BETS.sidra.get}
\alias{BETS.sidra.get}
\title{A function to extract Sidra series using their API}
\usage{
BETS.sidra.get(x, from, to, territory = c(n1 = "brazil", n2 = "region", n3 =
  "state", n6 = "city", n8 = "mesoregion", n9 = "microregion", n129 =
  "citizenship", n132 = "semiarid", n133 = "semiaridUF"), variable, cl = NULL,
  sections = NULL)
}
\arguments{
\item{x}{Sidra series number.}

\item{from}{A string or character vector specifying where the series shall start}

\item{to}{A string or character vector specifying where the series shall end}

\item{territory}{Specifies the desired territorial levels.}

\item{variable}{An integer describing what variable characteristics are to be returned. 
Defaults to all available.}

\item{cl}{A vector containing the classification codes in a vector.}

\item{sections}{A vector or a list of vectors if there are two or more classification
codes containing the desired tables from the classification.}
}
\description{
The different parameters define the table and its dimensions (periods, variables, territorial units and classification) to be consulted. The parameters that define the sections may vary from table to table. Henceforth, the Sidra function ranges between 5 mandatory arguments to 7. You can only choose one variable per series per request, but multiple sections within the variable.
}
\examples{
\dontrun{sidra=BETS.sidra.get(x = c(1612), from = 1990, to = 2015, territory = "brazil", variable =109)
sidra=BETS.sidra.get(x = c(3653), from = c("200201"), 
to = c("201703"), territory = "brazil", 
variable = 3135, sections = c(129316,129330), cl = 544)
sidra=BETS.sidra.get(x = c(3653), from = c("200201"), 
to = c("201512"), territory = "brazil",  variable = 3135, 
sections = "all", cl = 544)
sidra=BETS.sidra.get(x = c(1618), from = c("201703"), to = c("201703"), 
territory = "brazil",
variable = 109, sections=list(c(39427), c(39437,39441)), cl = c(49, 48))
trim - x = 1620; from = 199001; to = 201701;  territory = "brazil"; 
sections=list(c(90687)); cl =c(11255); variable = 583
sidra = BETS.sidra.get(x = 1620, from = 199001, to = 201701,  
territory = "brazil",
sections=list(c(90687)), cl =c(11255), variable = 583)}
}
\keyword{sidra}
