% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corrgram.R
\name{corrgram}
\alias{corrgram}
\title{Plot the ACF or the PACF of a time series}
\usage{
corrgram(ts, lag.max = 12, type = "correlation", mode = "simple",
  ci = 0.95, style = "plotly", knit = F)
}
\arguments{
\item{ts}{An object of type \code{ts} or \code{xts}. The time series for which the plot must be constructed.}

\item{lag.max}{A \code{numeric} value. The number of lags to be shown in the plot.}

\item{type}{A \code{character}. Can be either 'correlation' (for the ACF) or 'partial' (for the PACF).}

\item{mode}{A \code{character}. Set this parameter to 'bartlett' if you want the variance to be calculated according to \href{https://en.wikipedia.org/wiki/Correlogram#Statistical_inference_with_correlograms}{Bartlett's formula}. Otherwise, it is going to be simply equal to \code{1/sqrt(N)}.}

\item{ci}{A \code{numeric} value. The confidence interval to be shown in the plot.}

\item{style}{A \code{character}. Set this parameter to 'normal' if you want it made with ggplot2 or to 'plotly' if you want to be a \link[plotly]{plotly} object.}

\item{knit}{A \code{boolean}. If you're using this function to exhibit correlograms on a R dynamic report, set this parameter to true.}
}
\value{
A plot and a \code{vector} containing the correlations.
}
\description{
Plot correlograms using plot.ly and several other options that differ theses plots from \link[forecast]{forecast}s ACF and PACF.
}
\author{
Talitha Speranza \email{talitha.speranza@fgv.br}
}
