% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggm_compare_bf.default.R
\name{summary.ggm_compare_explore}
\alias{summary.ggm_compare_explore}
\title{Summary Method for \code{ggm_compare_explore} Objects}
\usage{
\method{summary}{ggm_compare_explore}(object, col_names = TRUE, ...)
}
\arguments{
\item{object}{An object of class \code{ggm_compare_explore}.}

\item{col_names}{Logical. Should the summary include the column names (default is \code{TRUE})?
Setting to \code{FALSE} includes the column numbers (e.g., \code{1--2}).}

\item{...}{Currently ignored.}
}
\value{
An object of class \code{summary.ggm_compare_explore}
}
\description{
Summarize the posterior hypothesis probabilities
}
\examples{
\donttest{
# note: iter = 250 for demonstrative purposes

# data
Y <- bfi

# males and females
Ymale <- subset(Y, gender == 1,
                   select = -c(gender,
                               education))[,1:10]

Yfemale <- subset(Y, gender == 2,
                     select = -c(gender,
                                 education))[,1:10]

##########################
### example 1: ordinal ###
##########################

# fit model
fit <- ggm_compare_explore(Ymale,  Yfemale,
                           type = "ordinal",
                           iter = 250,
                           progress = FALSE)
# summary
summ <- summary(fit)

summ
}
}
\seealso{
\code{\link{ggm_compare_explore}}
}
