% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constrained_post.R
\name{constrained_posterior}
\alias{constrained_posterior}
\title{Constrained Posterior Distribution}
\usage{
constrained_posterior(
  object,
  adj,
  method = "direct",
  iter = 5000,
  progress = TRUE,
  ...
)
}
\arguments{
\item{object}{An object of class \code{estimate} or \code{explore}}

\item{adj}{A \code{p} by \code{p} adjacency matrix. The zero entries denote the
elements that should be constrained to zero.}

\item{method}{Character string. Which method should be used ? Defaults to
the "direct sampler" (i.e., \code{method = "direct"}) described in
\insertCite{@page 122, section 2.4,  @lenkoski2013direct;textual}{BGGM}. The other
option is a Metropolis-Hastings algorithm (\code{MH}).
See details.}

\item{iter}{Number of iterations (posterior samples; defaults to 5000).}

\item{progress}{Logical. Should a progress bar be included (defaults to \code{TRUE}) ?}

\item{...}{Currently ignored.}
}
\value{
An object of class \code{contrained}, including

\itemize{

\item \code{precision_mean} The posterior mean for the precision matrix.

\item \code{pcor_mean} The posterior mean for the precision matrix.

\item \code{precision_samps} A 3d array of dimension \code{p} by \code{p} by \code{iter}
                             including the sampled precision matrices.

 \item \code{pcor_samps} A 3d array of dimension \code{p} by \code{p} by \code{iter}
                             including sampled partial correlations matrices.
}
}
\description{
Compute the posterior distribution
             with off-diagonal elements of the precision matrix constrained
             to zero.
}
\examples{
\donttest{

# data
Y <- bfi[,1:10]

# sample posterior
fit <- estimate(Y, iter = 100)

# select graph
sel <- select(fit)

# constrained posterior
post <- constrained_posterior(object = fit,
                              adj = sel$adj,
                              iter = 100,
                              progress = FALSE)

}
}
\references{
\insertAllCited{}
}
