% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irf.R
\name{add_shockinfo}
\alias{add_shockinfo}
\title{Adding shocks to 'shockinfo' argument}
\usage{
add_shockinfo(shockinfo=NULL, shock=NULL, restriction=NULL, sign=NULL, horizon=NULL, 
prob=NULL, scale=NULL, global=NULL, horizon.fillup=TRUE)
}
\arguments{
\item{shockinfo}{Dataframe to append shocks. If \code{shockinfo=NULL} appropriate dataframe for sign-restrictions will be created.}

\item{shock}{String element. Variable of interest for structural shock. Only possible to add restrictions to one structural shock at a time.}

\item{restriction}{Character vector with variables that are supposed to be sign restricted.}

\item{sign}{Character vector with signs.}

\item{horizon}{Numeric vector with horizons to which restriction should hold. Set \code{horizon.fillup} to \code{FALSE} to just restrict one specific horizon.}

\item{prob}{Number between zero and one determining the probability with which restriction is supposed to hold.}

\item{scale}{Scaling parameter.}

\item{global}{If set to \code{TRUE}, shock is defined as global shock.}

\item{horizon.fillup}{Default set to \code{TRUE}, horizon specified up to given horizon. Otherwise just one specific horizon is restricted.}
}
\description{
Adds automatically rows to 'shockinfo' data.frame for appropriate use in \code{irf}.
}
\details{
This is only possible for sign restriction, hence if \code{ident="sign"} in \code{get_shockinfo()}.
}
\seealso{
\code{\link{irf}}
}
