% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkSex.R
\name{recodeSex}
\alias{recodeSex}
\title{Recodes Sex Variable in a Pedigree Dataframe}
\usage{
recodeSex(
  ped,
  verbose = FALSE,
  code_male = NULL,
  code_na = NULL,
  code_female = NULL,
  recode_male = "M",
  recode_female = "F",
  recode_na = NA_character_
)
}
\arguments{
\item{ped}{A dataframe representing the pedigree data with a 'sex' column.}

\item{verbose}{A logical flag indicating whether to print progress and validation messages to the console.}

\item{code_male}{The current code used to represent males in the 'sex' column. At least one is needed.}

\item{code_female}{The current code used to represent females in the 'sex' column. If both male and female are NULL, no recoding is performed.}
}
\value{
A modified version of the input data.frame \code{ped}, containing an additional or modified 'sex_recode' column where the 'sex' values are recoded according to \code{code_male}. NA values in the 'sex' column are preserved.
}
\description{
This function serves as a wrapper around `checkSex` to specifically handle
the recoding of the 'sex' variable in a pedigree dataframe.
}
\seealso{
\code{\link{plotPedigree}}
}
\keyword{internal}
