% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readGedcom.R
\name{processEventLine}
\alias{processEventLine}
\title{Process Event Lines (Birth or Death)}
\usage{
processEventLine(event, block, i, record, pattern_rows)
}
\arguments{
\item{event}{A character string indicating the event type ("birth" or "death").}

\item{block}{A character vector of GEDCOM lines.}

\item{i}{The current line index where the event tag is found.}

\item{record}{A named list representing the individual's record.}

\item{pattern_rows}{A list with counts of GEDCOM tag occurrences.}
}
\value{
The updated record with parsed event information.#
}
\description{
Extracts event details (e.g., date, place, cause, latitude, longitude) from a block of GEDCOM lines.
For "birth": expect DATE on line i+1, PLAC on i+2, LATI on i+4, LONG on i+5.
For "death": expect DATE on line i+1, PLAC on i+2, CAUS on i+3, LATI on i+4, LONG on i+5.
}
