% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_ranges_species_bulk}
\alias{BIEN_ranges_species_bulk}
\title{Extract range data for large numbers of species}
\usage{
BIEN_ranges_species_bulk(
  species = NULL,
  directory = NULL,
  batch_size = 1000,
  return_directory = TRUE,
  use_parallel = FALSE
)
}
\arguments{
\item{species}{A vector of species or NULL (the default).  If NULL, all available ranges will be used.}

\item{directory}{The directory where range shapefiles will be stored.  If NULL, a temporary directoray will be used.}

\item{batch_size}{The number of ranges to download at once.}

\item{return_directory}{Should the directory be returned? Default is TRUE}

\item{use_parallel}{Logical.  Should batches be downloaded in parallel?  If set to TRUE, AND if parallel and foreach are available, parallel processing of downloads will use n-1 clusters.}
}
\value{
Optionally, the directory to which the files were saved.
}
\description{
BIEN_ranges_species_bulk downloads ranges for a large number of species using parrallel processing.
}
\note{
This function may take a long time (hours) to run depending on the number of cores, download speed, etc.
}
\examples{
\dontrun{
#To download all BIEN ranges maps:
BIEN_ranges_species_bulk()
}
}
\seealso{
Other range functions: 
\code{\link{BIEN_ranges_box}()},
\code{\link{BIEN_ranges_genus}()},
\code{\link{BIEN_ranges_intersect_species}()},
\code{\link{BIEN_ranges_list}()},
\code{\link{BIEN_ranges_load_species}()},
\code{\link{BIEN_ranges_shapefile_to_skinny}()},
\code{\link{BIEN_ranges_skinny_ranges_to_richness_raster}()},
\code{\link{BIEN_ranges_spatialpolygons}()},
\code{\link{BIEN_ranges_species}()}
}
\concept{range functions}
