% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialMarginal.R
\name{initialMarginal}
\alias{initialMarginal}
\title{Estimate initial values for fitting marginal dose-response curves}
\usage{
initialMarginal(data, transforms = NULL, ...)
}
\arguments{
\item{data}{Dose-response dataframe. Marginal data will be extracted from
it automatically.}

\item{transforms}{Transformation functions. If non-null, \code{transforms} is
a list containing 5 elements, namely biological and power transformations
along with their inverse functions and \code{compositeArgs} which is a list
with argument values shared across the 4 functions. See vignette for more
information.}

\item{...}{Further parameters that are currently not used}
}
\value{
Named vector with parameter estimates. Parameter names are consistent
  with parameter names in \code{\link{fitMarginals}}. \code{h1} and \code{h2}
  are Hill's slope coefficients for each of the compounds, \code{m1} and
  \code{m2} are their maximal response levels whereas \code{b} is the shared
  baseline. Lastly, \code{e1} and \code{e2} are log-transformed EC50 values.
}
\description{
This is a wrapper function which, when a dose-response dataframe is provided,
returns start value estimates for both compounds that could be supplied to
\code{\link{fitMarginals}} function. This function is also used by
\code{\link{fitMarginals}} if no initials values were supplied.
}
\details{
Note that this function returns \code{e1} and \code{2} which are
log-transformed inflection points for respective compounds.
}
\note{
Returns starting value for e = log(EC50).
}
\examples{
  data <- subset(directAntivirals, experiment == 1)
  ## Data must contain d1, d2 and effect columns
  transforms <- getTransformations(data)
  initialMarginal(data, transforms)
}
