% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cons.angular.dat.r
\name{cons.angular.dat}
\alias{cons.angular.dat}
\title{Angular data set generation from unit Frechet data.}
\usage{
cons.angular.dat(coordinates = c(1, 2, 3),
  frechetDat = get("frechetdat"), n = 100, displ = TRUE,
  invisible = TRUE, add = FALSE, lab1 = "w1", lab2 = "w2",
  lab3 = "w3", npoints = 60, col.polygon = "white", ...)
}
\arguments{
\item{coordinates}{Index vector of the columns in \code{frechetDat} to be retained to construct the angular data set.}

\item{frechetDat}{The data set. A matrix: each row is a multivariate record. May contain \var{NA}'s.}

\item{n}{The number of desired observations in the final angular data set. Should be less than \code{nrow(frechetDat)}}

\item{displ}{logical. Should the angular data set be plotted ?}

\item{invisible}{logical. Should the result be returned as invisible ?}

\item{add}{logical. Only used when \code{displ==TRUE}. Should the points be added to the current plot ?}

\item{lab1}{Character string: label for first component.}

\item{lab2}{Character string: label for second component.}

\item{lab3}{Character string: label for third component.}

\item{npoints}{The number of grid nodes on the squared grid containing the desired triangle.}

\item{col.polygon}{The background color outside the simplex.}

\item{...}{Additional graphical parameters and  arguments to be passed to function \code{\link[graphics]{plot.window}} and \code{\link[graphics]{points}}.}
}
\value{
The angular data set: A \code{n*length(coordinates)} matrix, containing values between zero and one, which rows sum to one: Each row is thus a point on the unit simplex of dimension \code{length(coordinates)-1}. Returned as  invisible if \code{invisible==TRUE}.
}
\description{
Builds an angular data set, retaining the points with largest radial component.
}
\details{
The data set \code{frechetDat} is assumed to be marginally unit  Frechet distributed.
}
\examples{
 \dontrun{cons.angular.dat()}
}
\keyword{datagen}
\keyword{manip}
\keyword{multivariate}
