% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_and_plot_results.R
\name{get_duration_diagnostic_plots}
\alias{get_duration_diagnostic_plots}
\title{Duration Times Plots: MCMC Diagnostic Plots}
\usage{
get_duration_diagnostic_plots(results, comps = 1:results$K)
}
\arguments{
\item{results}{results of duration times, i.e., results$results_duration}

\item{comps}{a vector of the components to plot; default is 1:duration_num_comp}
}
\value{
No return value, called for plotting MCMC diagnostic plots for duration times.
}
\description{
Provides the traceplots and autocorrelation plots for each gamma shape and rate parameter
}
\examples{

results <- BMRMM(foxp2_sm,num_cov=2,simsize=80)

# get diagnostic plots for all components
get_duration_diagnostic_plots(results$results_duration)

# get diagnostic plots for components 1,2
get_duration_diagnostic_plots(results$results_duration,comps=c(1,2))

}
