% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmhyb.r
\name{ConvertEvonetToIgraphWithNodeNumbers}
\alias{ConvertEvonetToIgraphWithNodeNumbers}
\title{Convert an evonet object into igraph}
\usage{
ConvertEvonetToIgraphWithNodeNumbers(phy.graph)
}
\arguments{
\item{phy.graph}{An ape::evonet object (a phylogeny stored in phylo format that also includes a reticulation matrix)}
}
\value{
An igraph network
}
\description{
ape can already convert from evonet to igraph; the advantage of this function is that it uses the node ids from the evonet object for labels in igraph.
}
\examples{
phy <- ape::rcoal(5)
phy.evo <- ape::evonet(phy, from=1, to=2)
plot(phy.evo) # this is the ape plot
phy.igraph <- ConvertEvonetToIgraphWithNodeNumbers(phy.evo)
plot(phy.igraph)
}
