# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title element_wise_mult
#'
#' @description This is a function that takes in two matrices of dimension
#' nxB and nxk and returns a Bxk matrix that comes from
#' element-wise multiplication of every column 
#' in the first matrix times the entire second matrix and the
#' averaging over the n-dimension.  It is equivalent (but faster
#' than) the following R code:
#' `sapply(1:biters, function(b) sqrt(n)*colMeans(Umat[,b]*inf.func))`
#' .  This function is particularly useful for fast computations
#' using the multiplier bootstrap.
#'
#' @param U nxB matrix (e.g., these could be a matrix of
#'  Rademachar weights for B bootstrap iterations using the
#'  multiplier bootstrap
#' @param inf_func nxk matrix of (e.g., these could be a matrix
#'  containing the influence function for different parameter
#'  estimates)
#'
#' @return a Bxk matrix
NULL

#' @title multiplier_bootstrap
#'
#' @description A function that takes in an influence function (an
#' nxk matrix) and the number of bootstrap iterations and
#' returns a Bxk matrix of bootstrap results. This function
#' uses Rademechar weights.
#' 
#' @param inf_func nxk matrix of (e.g., these could be a matrix
#'  containing the influence function for different parameter
#'  estimates)
#' @param biters the number of bootstrap iterations
#'
#' @return a Bxk matrix
#' @export
multiplier_bootstrap <- function(inf_func, biters) {
    .Call('_BMisc_multiplier_bootstrap', PACKAGE = 'BMisc', inf_func, biters)
}

