% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk.R
\name{rk}
\alias{rk}
\title{Kernel density sampling function}
\usage{
rk(n, distr = NULL, mu = NULL, sigma = NULL)
}
\description{
This function simulates from a density.  There are 4 density options (1 =
Gaussian, 2 = Gamma, 3 = Beta, 4 = double exponential, 5 = lognormal). All
densities are parametrized in terms of mean and standard deviation.
}
\details{
For internal use.
}
\examples{

## The function is currently defined as
function(n, distr = NULL, mu = NULL, sigma = NULL) {
  if (is.null(distr)) {
    stop("Argument \\"distr\\" should be defined numeric with possible values 1,2,3,4 or 5")
  }
  else if (distr == 1) {
    a <- ifelse(is.null(mu), 0, mu)
    b <- ifelse(is.null(sigma), 1, sigma)
    rk <- rnorm(n, mean = a, sd = b)
  }
  else if (distr == 2) {
    a <- ifelse(is.null(mu), 0, mu)
    b <- ifelse(is.null(sigma), 1 / sqrt(2), sigma / sqrt(2))
    rk <- a + b * sample(c(-1, +1), size = n, replace = TRUE) *
      rexp(n)
  }
  else if (distr == 3) {
    a <- ifelse(is.null(mu), exp(1 / 2), log(mu / sqrt(1 + (sigma / mu)^2)))
    b <- ifelse(is.null(sigma), exp(1) * (exp(1) - 1), sqrt(log(1 +
      (sigma / y)^2)))
    rk <- rlnorm(n, meanlog = a, sdlog = b)
  }
  else if (distr == 4) {
    a <- ifelse(is.null(mu), 1, mu^2 / sigma^2)
    b <- ifelse(is.null(sigma), 1, mu / sigma^2)
    rk <- rgamma(n, shape = a, rate = b)
  }
  else if (distr == 5) {
    a <- ifelse(is.null(mu), 0.5, (1 - mu) * (mu / sigma)^2 -
      mu)
    b <- ifelse(is.null(sigma), 1 / sqrt(12), (mu * (1 - mu) / sigma^2 -
      1) * (1 - mu))
    if (any(c(a, b) <= 0)) {
      stop(paste(
        "\\nNegative Beta parameters:\\n a =", a,
        ";\\t b =", b
      ))
    }
    rk <- rbeta(n, shape1 = a, shape2 = b)
  }
  else {
    stop("Argument \\"distr\\" should be defined numeric with possible values 1,2,3,4 or 5")
  }
  return(rk)
}
}
\keyword{internal}
