% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Life}
\alias{Life}
\title{Life expectancy of men and women in U.S.}
\format{A data frame/tibble with eight observations on three variables
\describe{ 
\item{year}{a numeric vector indicating year} 
\item{men}{life expectancy for men (in years)} 
\item{women}{life expectancy for women (in years)} 
}}
\source{
National Center for Health Statistics.
}
\usage{
Life
}
\description{
Data for Exercise 1.31
}
\examples{

plot(men ~ year, type = "l", ylim = c(min(men, women), max(men, women)), 
    col = "blue", main = "Life Expectancy vs Year", ylab = "Age", 
    xlab = "Year", data = Life)
lines(women ~ year, col = "red", data = Life)
text(1955, 65, "Men", col = "blue")
text(1955, 70, "Women", col = "red")

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
