% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Windmill}
\alias{Windmill}
\title{Direct current produced by different wind velocities}
\format{A data frame/tibble with 25 observations on two variables
\describe{ 
\item{velocity}{wind velocity (miles per hour)} 
\item{output}{power generated (DC volts)} 
}}
\source{
Joglekar, et al. (1989), Lack of Fit Testing when Replicates Are Not Available,
\emph{The American Statistician, 43},(3), 135-143.
}
\usage{
Windmill
}
\description{
Data for Exercise 9.34
}
\examples{

summary(lm(output ~ velocity, data = Windmill))
anova(lm(output ~ velocity, data = Windmill))

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
