% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Challeng}
\alias{Challeng}
\title{Temperatures and O-ring failures for the launches of the space shuttle
Challenger}
\format{
A data frame/tibble with 25 observations on four variables
\describe{ 
\item{flight}{a character variable indicating the flight}
\item{date}{date of the flight} 
\item{temp}{temperature (in fahrenheit)}
\item{failures}{number of failures} 
}
}
\source{
Dalal, S. R., Fowlkes, E. B., Hoadley, B. 1989. \dQuote{Risk Analysis of the Space Shuttle: Pre-Challenger 
Prediction of Failure.} 
\emph{Journal of the American Statistical Association}, 84, No. 408, 945-957.
}
\usage{
Challeng
}
\description{
Data for Examples 1.11, 1.12, 1.13, 2.11 and 5.1
}
\examples{

stem(Challeng$temp)
summary(Challeng$temp)
IQR(Challeng$temp)
quantile(Challeng$temp)
fivenum(Challeng$temp)
stem(sort(Challeng$temp)[-1])
summary(sort(Challeng$temp)[-1])
IQR(sort(Challeng$temp)[-1])
quantile(sort(Challeng$temp)[-1])
fivenum(sort(Challeng$temp)[-1])
par(mfrow=c(1, 2))
qqnorm(Challeng$temp)
qqline(Challeng$temp)
qqnorm(sort(Challeng$temp)[-1])
qqline(sort(Challeng$temp)[-1])
par(mfrow=c(1, 1))

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
