% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semiparaKernelEstimate.R
\name{semiparaKernelEstimate}
\alias{semiparaKernelEstimate}
\title{Estimate the semi-parametric synthetic (log) likelihood}
\usage{
semiparaKernelEstimate(
  ssy,
  ssx,
  kernel = "gaussian",
  shrinkage = NULL,
  penalty = NULL,
  log = TRUE
)
}
\arguments{
\item{ssy}{The observed summary statisic.}

\item{ssx}{A matrix of the simulated summary statistics. The number
of rows is the same as the number of simulations per iteration.}

\item{kernel}{A string argument indicating the smoothing kernel to pass
into \code{density} for estimating the marginal distribution of each
summary statistic. Only ``gaussian" and ``epanechnikov" are available. The
default is ``gaussian".}

\item{shrinkage}{A string argument indicating which shrinkage method to
be used. The default is \code{NULL}, which means no shrinkage is used.
Current options are ``glasso'' for the graphical lasso method of
\insertCite{Friedman2008;textual}{BSL} and ``Warton'' for the ridge
regularisation method of \insertCite{Warton2008;textual}{BSL}.}

\item{penalty}{The penalty value to be used for the specified shrinkage
method. Must be between zero and one if the shrinkage method is ``Warton''.}

\item{log}{A logical argument indicating if the log of likelihood is
given as the result. The default is \code{TRUE}.}
}
\value{
The estimated synthetic (log) likelihood value.
}
\description{
This function computes the semi-parametric synthetic likelihood
  estimator of \insertCite{An2018}{BSL}. The advantage of this
  semi-parametric estimator over the standard synthetic likelihood estimator
  is that the semi-parametric one is more robust to non-normal summary
  statistics. Kernel density estimation is used for modelling each univariate
  marginal distribution, and the dependence structure between summaries are
  captured using a Gaussian copula. Shrinkage on the correlation matrix
  parameter of the Gaussian copula is helpful in decreasing the number of
  simulations.
}
\examples{
data(ma2)
ssy <- ma2_sum(ma2$data)
m <- newModel(fnSim = ma2_sim, fnSum = ma2_sum, simArgs = ma2$sim_args,
              theta0 = ma2$start, sumArgs = list(delta = 0.5))
ssx <- simulation(m, n = 300, theta = c(0.6, 0.2), seed = 10)$ssx

# check the distribution of the first summary statistic: highly non-normal
plot(density(ssx[, 1]))

# the standard synthetic likelihood estimator over-estimates the likelihood here
gaussianSynLike(ssy, ssx)
# the semi-parametric synthetic likelihood estimator is more robust to non-normality
semiparaKernelEstimate(ssy, ssx)
# using shrinkage on the correlation matrix of the Gaussian copula is also possible
semiparaKernelEstimate(ssy, ssx, shrinkage = "Warton", penalty = 0.8)

}
\references{
\insertAllCited{}

\insertRef{Friedman2008}{BSL}

\insertRef{Warton2008}{BSL}

\insertRef{Boudt2012}{BSL}
}
\seealso{
Other available synthetic likelihood estimators:
  \code{\link{gaussianSynLike}} for the standard synthetic likelihood
  estimator, \code{\link{gaussianSynLikeGhuryeOlkin}} for the unbiased
  synthetic likelihood estimator, \code{\link{synLikeMisspec}} for the
  Gaussian synthetic likelihood estimator for model misspecification.
}
