% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_modification.R
\name{minmod_model}
\alias{minmod_model}
\title{Minimal modification of whole Boolean model}
\usage{
minmod_model(bm, index = NULL, overlap_gene = NULL, sep_list = F,
  encoded = F, model_encoding, and_bool = NULL, self_loop = F)
}
\arguments{
\item{bm}{S4 BoolModel object.}

\item{index}{integer. Specifying rule of which gene to modify. If NULL, modifies all rules in the model. Defaults to NULL.}

\item{overlap_gene}{character vector. Specify which genes are present in both model and data inputs.}

\item{sep_list}{logical. Separate add and del lists.}

\item{encoded}{logical. Return Boolean models in encoded form to save space.}

\item{model_encoding}{list. Only used if encoded=T.}

\item{and_bool}{logical. Default to check_and().}

\item{self_loop}{logical. Whether to allow self_loop in random starting model. Default to F.}
}
\description{
This function generates all possible boolean models minimally modified. Returns a lists of 2 lists, deleted models and added models
}

