% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{model_train}
\alias{model_train}
\title{Training Model}
\usage{
model_train(cdata, bmodel = NULL, istate = NULL, max_varperrule = 6,
  and_bool = T, self_loop = F, con_thre = 0.3, tol = 1e-06,
  verbose = F, detailed_output = F)
}
\arguments{
\item{cdata}{data frame of expression data. Should have state(row) x gene(column).}

\item{bmodel}{Boolean model in data frame. If NULL, use a random Boolean model. Defaults to NULL.}

\item{istate}{data frame. Must have only 1 row, which represents 1 initial state. Defaults to NULL.}

\item{max_varperrule}{integer. Maximum number of terms per rule (combining both act and inh rule). Note that this number must be higher than number of genes. Defaults to 3.}

\item{and_bool}{logical. Whether to consider AND terms. IF bmodel is not NULL, defaults to whether AND interaction is included in bmodel. If bmodel is NULL, then defaults to TRUE.}

\item{self_loop}{logical. Whether to allow self_loop in random starting model. Default to F.}

\item{con_thre}{numerical. Threshold used to generating the final consensus model. Must be between 0 and 1.}

\item{tol}{numeric. Tolerance in ending condition. Default to 1e-6. It cannot be lower than .Machine$double.eps ^ 0.5.}

\item{verbose}{logical. Whether to give detailed output to the screen. Defaults to F.}

\item{detailed_output}{logical. Whether to return only the model inferred, or all the details obtained during optimisation. Defaults to F.}
}
\description{
This function performs model training to find the best model, using information from data. It requires an initial state supplied to perform the search, and an initial model can also be supplied to be included in the initial population.
Note that if a model is supplied, and the genes in the model is different from the genes in the data, only the genes overlapping between model and data will be retained for further analysis.
}
\examples{
data(wilson_raw_data)
cdata = initialise_raw_data(wilson_raw_data, max_expr = 'low')

#select only relevant cells.
cell_ind = grepl('cmp', rownames(cdata)) | grepl('gmp', rownames(cdata)) 
fcdata = cdata[cell_ind,]

#select genes to be included.
gene_ind = c('fli1', 'gata1', 'gata2', 'gfi1', 'scl', 'sfpi1') 
fcdata = fcdata[, gene_ind]

final_model = model_train(cdata=fcdata, max_varperrule=2)
plotBM(final_model)

}

