% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output_format.R
\name{outstate_graph}
\alias{outstate_graph}
\title{Generate state transition graph}
\usage{
outstate_graph(mstate, bmodel, directed = F, record.both = F,
  filepath = getwd())
}
\arguments{
\item{mstate}{data frame. It should be a state(row) x gene(column) df.}

\item{bmodel}{S4 BoolModel object.}

\item{directed}{logical. Indicates whether to make directed edges or not. Default to FALSE.}

\item{record.both}{logical. Indicates whether to also record nodes that have no edges. Default to FALSE.}

\item{filepath}{character vector. Specify path (AND NOT file name). Default to current working directory, i.e. getwd(). Set to NULL to disable file output.}
}
\description{
This function generates a state transition graph using a Boolean model and its state space. Each node represent a state. All nodes in this graph is linked by an edge only if the 2 states have different value in only 1 gene. The output is readable by Cytoscape and Gephi.
}

