% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rand_model.R
\name{gen_two_rmodel_dag}
\alias{gen_two_rmodel_dag}
\title{Generate two random DAG Boolean models with a specified number of steps apart}
\usage{
gen_two_rmodel_dag(var, steps, mvar = length(var), in_amat = NULL,
  acyclic = T)
}
\arguments{
\item{var}{character vector. A vector of single genes/variables to be used in the model.}

\item{steps}{integer. Number of steps apart between the two models. If steps=0, give completely random starting model.}

\item{mvar}{integer. Maximum number of variables in act or inh rule. Default to length(var).}

\item{in_amat}{matrix. Provide adjacency matrix of first model.}

\item{acyclic}{logical. Whether to restrict the model to being acyclic or not. Defaults to TRUE.}
}
\description{
This function generates a random DAG Boolean model, then get another random DAG Boolean model that is a specified number of steps apart by adding and/or removing genes. 
Difficult to generate completely directed graph with a specified number of steps apart.
}

