% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{coefs.start}
\alias{coefs.start}
\title{Initial values for optimization}
\usage{
coefs.start(model = "Generic", yt, linkg = c("linear", "linear"),
  xreg = NULL, p = 0, q = 0, d = TRUE, y.start = NULL,
  y.lower = -Inf, y.upper = Inf, lags = list(), fixed.values = list(),
  fixed.lags = list())
}
\arguments{
\item{model}{character; The model to be fitted to the data. One of
\code{"BARFIMA"}, \code{"KARFIMA"}, \code{"GARFIMA"}, \code{"BARC"}.
Default is "Generic" so that no specific structure is assumed.}

\item{yt}{a univariate time series. Missing values (NA's)
are not  allowed.}

\item{linkg}{character; one of  \code{"linear"}, \code{"logit"},
\code{"log"}, \code{"loglog"}, \code{"cloglog"}.
If only one name is provided, the same link will be used for the conditional mean, that is
to define \eqn{g(\mu)} and for the observed time series in the AR part
of the model, that is, \eqn{g(y[t])}.}

\item{xreg}{optional; a vector or matrix of external regressors,
which must have the same number of rows as x.}

\item{p}{an integer; the AR order. Default is zero.}

\item{q}{an integer; for \code{BARC} models represents the dimension of
the parameter associated to the map \eqn{T}. For other models is the
MA order. Default is zero.}

\item{d}{logical; if FALSE, \eqn{d} is fixed as zero. Default is TRUE.}

\item{y.start}{optional; an initialization value for \eqn{y[t]},
for \eqn{t \le 0}, to be used in the AR recursion. If not provided,
the default assume \eqn{y[t] = 0}, when using a \code{"linear"} link for
 \eqn{yt}, and \eqn{g(y[t]) = 0}, otherwise.}

\item{y.lower}{lower limit for the distribution support.
Default is \code{-Inf}.}

\item{y.upper}{upper limit for the distribution support.
Default is \code{Inf}.}

\item{lags}{optional; a list with the components \code{beta},
\code{phi} and \code{theta} specifying which lags must be included
in the model. An empty list or missing component indicates that, based on the values \code{nreg},
\code{p}  e \code{q}), all lags must be includes in the model.}

\item{fixed.values}{optional; a list with the fixed values for
each component, if any. If fixed values are provided, either \code{lags}
or \code{fixed.lags} must also be provided.}

\item{fixed.lags}{optional; a list with the components \code{beta},
\code{phi} and \code{theta} specifying which lags must be fixed.
An empty list implies that fixed values will be set based on
\code{lags}.}
}
\value{
a list with starting values for the parameters of the selected
model. Possible outputs are:

 \item{alpha}{the intercept}
 \item{beta}{the coefficients for the regressors}
 \item{phi}{the AR coefficients}
 \item{theta}{for BARC models, the map parameter.  For any other model,
 the MA coefficients}
 \item{d}{the long memory parameter}
 \item{nu}{the precison parameter}
}
\description{
This function calculates initial values for the parameter vector,
to pass to the optimization function.
}
\examples{
mu = 0.5
nu = 20

yt = rbeta(100, shape1 = mu*nu, shape2 = (1-mu)*nu)
coefs.start(model = "BARFIMA", yt = yt,
            linkg = "linear", d = FALSE,
            y.lower = 0, y.upper = 1)

yt = rgamma(100, shape = nu, rate = mu*nu)
coefs.start(model = "GARFIMA", yt = yt,
            linkg = "linear", d = FALSE,
            y.lower = 0, y.upper = Inf)

}
