% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link.R
\name{link.btsr}
\alias{link.btsr}
\title{Create a Link for BTSR models}
\usage{
link.btsr(link)
}
\arguments{
\item{link}{character; one of  \code{"linear"}, \code{"logit"},
\code{"log"}, \code{"loglog"}, \code{"cloglog"}. See \sQuote{Details}.}
}
\value{
An object of class \code{"link-btsr"}, a list with components

 \item{linkfun}{Link function \code{function(mu)}}
 \item{linkinv}{Inverse link function \code{function(eta)}}
 \item{linkdif}{Derivative \code{function(mu)} \eqn{d\eta / d\mu}{deta/dmu}}
 \item{mu.eta}{Derivative \code{function(eta)} \eqn{d\mu / d\eta}{dmu/deta}}
 \item{name}{a name to be used for the link}
}
\description{
Given the name of a link, this function returns a link function,
 an inverse link function, the derivative   \eqn{d\eta / d\mu}{deta/dmu}
 and the derivative \eqn{d\mu / d\eta}{dmu/deta}.
}
\details{
The available links are:

 linear: \eqn{f(x) = ax}, for \eqn{a} real.  The parameter is set using the
 argument \code{ctt.ll}, when invoking the functions created by \code{link.btsr}

 logit:  \eqn{f(x) = log(x/(1-x))}

 log:    \eqn{f(x) = log(x)}

 loglog: \eqn{f(x) = log(-log(x))}

 cloglog: \eqn{f(x) = log(-log(1-x))}
}
\examples{
mylink <- BTSR::link.btsr("linear")
y = 0.8
a = 3.4
gy = a*y

mylink$linkfun(mu = y, ctt.ll = a); gy
mylink$linkinv(eta = gy, ctt.ll = a); y
mylink$diflink(mu = y, ctt.ll = a); a
mylink$mu.eta(eta = gy, ctt.ll = a); 1/a


}
