% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pnbd.R
\name{pnbd.LL}
\alias{pnbd.LL}
\title{Pareto/NBD Log-Likelihood}
\usage{
pnbd.LL(params, x, t.x, T.cal, hardie = TRUE)
}
\arguments{
\item{params}{Pareto/NBD parameters - a vector with r, alpha, s, and beta, in
that order. r and alpha are unobserved parameters for the NBD transaction
process. s and beta are unobserved parameters for the Pareto (exponential
gamma) dropout process.}

\item{x}{number of repeat transactions in the calibration period T.cal, or a
vector of transaction frequencies.}

\item{t.x}{time of most recent repeat transaction, or a vector of recencies.}

\item{T.cal}{length of calibration period, or a vector of calibration period
lengths.}

\item{hardie}{if TRUE, use \code{\link{h2f1}} instead of
\code{\link[hypergeo]{hypergeo}}.}
}
\value{
A vector of log-likelihoods as long as the longest input vector (x,
t.x, or T.cal).
}
\description{
Calculates the log-likelihood of the Pareto/NBD model.
}
\examples{
# Returns the log likelihood of the parameters for a customer who
# made 3 transactions in a calibration period that ended at t=6,
# with the last transaction occurring at t=4.
pnbd.LL(params, x=3, t.x=4, T.cal=6, hardie = TRUE)

# We can also give vectors as function parameters:
set.seed(7)
x <- sample(1:4, 10, replace = TRUE)
t.x <- sample(1:4, 10, replace = TRUE)
T.cal <- rep(4, 10)
pnbd.LL(params, x, t.x, T.cal, hardie = TRUE)
}
\references{
Fader, Peter S., and Bruce G.S. Hardie. "A Note on Deriving the
Pareto/NBD Model and Related Expressions." November. 2005. Web.
\url{http://www.brucehardie.com/notes/008/}
}
\seealso{
\code{\link{pnbd.EstimateParameters}}
}
