% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/predict.R
\docType{methods}
\name{predict,est.hiddenDiffusion-method}
\alias{predict,est.hiddenDiffusion-method}
\title{Prediction for a hidden diffusion process}
\usage{
\S4method{predict}{est.hiddenDiffusion}(object, t, burnIn, thinning, b.fun.mat,
  which.series = c("new", "current"), M2pred = 10, cand.length = 1000,
  pred.alg = c("Distribution", "Trajectory", "simpleTrajectory",
  "simpleBayesTrajectory"), sample.length, grid, plot.prediction = TRUE)
}
\arguments{
\item{object}{class object of MCMC samples: "est.hiddenDiffusion", created with method \code{\link{estimate,hiddenDiffusion-method}}}

\item{t}{vector of time points to make predictions for}

\item{burnIn}{burn-in period}

\item{thinning}{thinning rate}

\item{b.fun.mat}{matrix-wise definition of drift function (makes it faster)}

\item{which.series}{which series to be predicted, new one ("new") or further development of current one ("current")}

\item{M2pred}{optional, if current series to be predicted and t missing, \code{M2pred} variables will be predicted
with the observation time distances}

\item{cand.length}{length of candidate samples (if method = "vector")}

\item{pred.alg}{prediction algorithm, "Distribution", "Trajectory", "simpleTrajectory" or "simpleBayesTrajectory"}

\item{sample.length}{number of samples to be drawn, default is the number of posterior samples}

\item{grid}{fineness degree of sampling approximation}

\item{plot.prediction}{if TRUE, prediction intervals are plotted}
}
\description{
Bayesian prediction of the model,
  \eqn{Z_i = Y_{t_i} + \epsilon_i, dY_t = b(\phi,t,Y_t)dt + \gamma \widetilde{s}(t,Y_t)dW_t}.
}
\examples{
\dontrun{
model <- set.to.class("hiddenDiffusion", parameter = list(phi = 5, gamma2 = 1, sigma2 = 0.1))
t <- seq(0, 1, by = 0.01)
data <- simulate(model, t = t)
est_hiddiff <- estimate(model, t, data$Z, 100)  # nMCMC should be much larger!
plot(est_hiddiff)

pred_hiddiff <- predict(est_hiddiff, t = seq(0, 1, by = 0.1))
pred_hiddiff2 <- predict(est_hiddiff, which.series = "current")

pred_hiddiff <- predict(est_hiddiff, pred.alg = "simpleTrajectory", sample.length = 100)
pred_hiddiff <- predict(est_hiddiff, pred.alg = "simpleBayesTrajectory")
}
}
\references{
Hermann, S. (2016a). BaPreStoPro: an R Package for Bayesian Prediction of Stochastic Processes.
SFB 823 discussion paper 28/16.

Hermann, S. (2016b). Bayesian Prediction for Stochastic Processes based on the Euler Approximation Scheme.
SFB 823 discussion paper 27/16.
}

