% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mk_toy.R
\name{mk_toy}
\alias{mk_toy}
\title{Make a toy dataset to test the 3d BaTFLED model.}
\usage{
mk_toy(params)
}
\arguments{
\item{params}{list of parameters created with \code{get_data_params}}
}
\value{
a list containing elements of the model
\describe{
\item{mode1.X}{Input data for mode 1}
\item{mode2.X}{Input data for mode 2}
\item{mode3.X}{Input data for mode 3}
\item{mode1.A}{Projection matrix for mode 1}
\item{mode2.A}{Projection matrix for mode 2}
\item{mode3.A}{Projection matrix for mode 3}
\item{mode1.H}{Latent matrix for mode 1}
\item{mode2.H}{Latent matrix for mode 2}
\item{mode3.H}{Latent matrix for mode 3}
\item{core}{Core tensor if \code{params$decomp=='Tucker'}}
\item{resp}{Response tensor}
}
}
\description{
Returns a toy model with the specified size, sparsity and noise generated
either with a CP or Tucker factorization model.
Values in predictor matrices (X1, X2, X3) are pulled from a standard normal 
distribuion. Dummy names are given to the predictors.
}
\examples{
data.params <- get_data_params(c('decomp=Tucker'))
toy <- mk_toy(data.params)

data.params <- get_data_params(c('decomp=CP'))
toy <- mk_toy(data.params)
}

