% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Arena.R
\docType{methods}
\name{changeDiff}
\alias{changeDiff}
\alias{changeDiff,Arena-method}
\title{Change substance concentration patterns in the environment}
\usage{
changeDiff(object, newdiffmat, mediac)

\S4method{changeDiff}{Arena}(object, newdiffmat, mediac)
}
\arguments{
\item{object}{An object of class Arena.}

\item{newdiffmat}{A matrix giving the new gradient matrix of the specific substances in the environment.}

\item{mediac}{A character vector giving the names of substances, which should be added to the environment (the default takes all possible substances).}
}
\description{
The generic function \code{changeDiff} changes specific substance concentration patterns in the environment.
}
\details{
This function can be used to add gradients of specific substances in the environment. The default conditions in \code{changeSubs} assumes an equal concentration in every grid cell of the environment.
}
\examples{
data(Ec_core, envir = environment()) #get Escherichia coli core metabolic model
bac <- Bac(Ec_core,deathrate=0.05,
           minweight=0.05,growtype="exponential") #initialize a bacterium
arena <- Arena(n=20,m=20) #initialize the environment
arena <- addOrg(arena,bac,amount=10) #add 10 organisms
arena <- addSubs(arena,30) #add all substances with no concentrations.
gradient <- matrix(1:200,20,20)
arena <- changeDiff(arena,gradient,c("EX_glc(e)","EX_o2(e)","EX_pi(e)"))
# add substances glucose, oxygen and phosphate
}
\seealso{
\code{\link{Arena-class}} and \code{\link{changeSub}}
}

