% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Organism.R
\docType{class}
\name{Organism-class}
\alias{Organism-class}
\title{Structure of the S4 class "Organism"}
\description{
Structure of the S4 class \code{Organism} representing the organisms present in the environment.
}
\section{Slots}{

\describe{
\item{\code{lbnd}}{A numeric vector containing the lower bounds of the model structure.}

\item{\code{ubnd}}{A numeric vector containing the upper bounds of the model structure.}

\item{\code{type}}{A character vector containing the description of the organism.}

\item{\code{medium}}{A character vector containing all exchange reactions of the organism.}

\item{\code{lpobj}}{A sybil optimization object containing the linear programing problem.}

\item{\code{fbasol}}{A list with the solutions of the flux balance analysis.}

\item{\code{lyse}}{A boolean variable indicating if the organism should lyse after death.}

\item{\code{feat}}{A list containing conditional features for the object (contains at the momement only biomass components for lysis).}

\item{\code{deathrate}}{A numeric value giving the factor by which the biomass should be reduced in every iteration if no growth is possible (default (E.coli): 0.21 pg)}

\item{\code{minweight}}{A numeric value giving the growth limit at which the organism dies. (default (E.coli): 0.083 pg)}

\item{\code{growtype}}{A character vector giving the functional type for growth (linear or exponential).}

\item{\code{kinetics}}{A List containing Km and v_max values for each reactions.}

\item{\code{speed}}{A integer vector representing the speed by which bacterium is moving (given by cell per iteration).}

\item{\code{cellarea}}{A numeric value indicating the surface that one organism occupies (default (E.coli): 4.42 mu_m^2)}

\item{\code{maxweight}}{A numeric value giving the maximal dry weight of single organism (default (E.coli): 1.172 pg)}

\item{\code{cellweight_mean}}{A numeric giving the mean of starting biomass (default (E.coli): 0.489 pg)}

\item{\code{cellweight_sd}}{A numeric giving the standard derivation of starting biomass (default (E.coli): 0.132 pg)}

\item{\code{model}}{Object of class sybil::modelorg containging the genome sclae metabolic model}

\item{\code{algo}}{Algorithm to be used during optimization (default fba)}

\item{\code{rbiomass}}{Name of biomass reactions which is used for growth model (set automatically but needs input if objective is not biomass optimization)}

\item{\code{limit_growth}}{If true then a upper bound on growth will be set, see maxweight (default: True).}

\item{\code{coupling_constraints}}{List with coupling parameters.}

\item{\code{predator}}{Name of organism which can kill this one.}
}}

