% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bacen_api.R
\name{bacen_api}
\alias{bacen_api}
\title{Connection to the Central Bank API}
\usage{
bacen_api(url, httr = TRUE)
}
\arguments{
\item{url}{A string containing the BACEN API URL for the desired series.}

\item{httr}{A logical value. If `TRUE`, the function uses the `httr` package for the connection.
Otherwise, it uses the `httr2` package. The default value is `TRUE`.}
}
\value{
Returns the data retrieved from the BACEN API.
}
\description{
This function establishes a connection with the Central Bank of Brazil (BACEN) API,
using the `httr` or `httr2` packages to retrieve data in JSON format and convert
it into a readable format such as data frames.
}
\examples{
# Example using the `httr` package:
url <- bacen_url(433, "01/01/2020", "31/12/2023") # in the format "dd/mm/yyyy"
data <- bacen_api(url, httr = TRUE)



}
