% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Barycenter.R
\name{WaBarycenter}
\alias{WaBarycenter}
\title{Regularized Wasserstein Barycenters}
\usage{
WaBarycenter(images, maxIter = 10, lambda = FALSE, costm = FALSE)
}
\arguments{
\item{images}{A list of matrices satisfying the prerequisites described above.}

\item{maxIter}{Maximum number of iterations.}

\item{lambda}{Non-negative regularization parameter (for large lambda the regularized Barycenter is close to its true counterpart). If FALSE the algorithm uses a lambda depending on \code{costm}.}

\item{costm}{A matrix of pairwise distances between the locations. If FALSE the algorithm uses the usual euclidean distance matrix on a [0,1]x[0,1] equidistant pixel grid.}
}
\value{
The Barycenter of the matrices, represented by a \eqn{n x m} matrix.

Given the MNIST dataset, a Barycenter of the digit three is shown below. The Barycenter is based on 4351 images each represented by
a 28 x 28 pixel grid, respectively. The values for \code{lambda} and \code{maxIter} were set by default. The dataset is also available in this package (c.f. \link{three}).

\figure{threeMNIST.png}{test}
}
\description{
\code{WaBarycenter} takes in a list of matrices representing joint measures on the row and column space and outputs the
corresponding Barycenter.
The list has to consist of matrices having all the same dimensions, for instance, each matrix represents the normalized weights of the corresponding pixels of images.
}
\examples{
#Computation of a Barycenter based on five images representing the digit eight, respectively.
WaBarycenter(eight,lambda=10)
#For a more reasonable but longer computation!
\dontrun{WaBarycenter(eight)}
}
\references{
Cuturi, M.: \code{Fast Computation of Wasserstein Barycenters}, Proceedings of the International Conference on Machine Learning, Beijing, China, 2014
}
\author{
Marcel Klatt
}
