% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/subtract.R
\name{subtract}
\alias{subtract}
\alias{subtract,TidySet,characterORfactor,characterORfactor-method}
\title{Subtract}
\usage{
subtract(object, set_in, not_in, ...)

\S4method{subtract}{TidySet,characterORfactor,characterORfactor}(
  object,
  set_in,
  not_in,
  name = NULL,
  keep = TRUE,
  keep_relations = keep,
  keep_elements = keep,
  keep_sets = keep
)
}
\arguments{
\item{object}{A TidySet object.}

\item{set_in}{Name of the sets where the elements should be present.}

\item{not_in}{Name of the sets where the elements should not be present.}

\item{...}{Placeholder for other arguments that could be passed to the
method. Currently not used.}

\item{name}{Name of the new set. By default it adds a "C".}

\item{keep}{Logical value to keep all the other sets.}

\item{keep_relations}{A logical value if you wan to keep old relations.}

\item{keep_elements}{A logical value if you wan to keep old elements.}

\item{keep_sets}{A logical value if you wan to keep old sets.}
}
\value{
A \code{TidySet} object.
}
\description{
Elements in a set not present in the other set. Equivalent to
\code{\link[=setdiff]{setdiff()}}.
}
\section{Methods (by class)}{
\itemize{
\item \code{subtract(
  object = TidySet,
  set_in = characterORfactor,
  not_in = characterORfactor
)}: Elements present in sets but not in other sets

}}
\examples{
relations <- data.frame(
    sets = c("A", "A", "B", "B", "C", "C"),
    elements = letters[seq_len(6)],
    fuzzy = runif(6)
)
TS <- tidySet(relations)
subtract(TS, "A", "B")
subtract(TS, "A", "B", keep = FALSE)
}
\seealso{
\code{\link[=setdiff]{setdiff()}}

Other complements: 
\code{\link{complement_element}()},
\code{\link{complement_set}()},
\code{\link{complement}()}

Other methods that create new sets: 
\code{\link{complement_element}()},
\code{\link{complement_set}()},
\code{\link{intersection}()},
\code{\link{union}()}

Other methods: 
\code{\link{TidySet-class}},
\code{\link{activate}()},
\code{\link{add_column}()},
\code{\link{add_relation}()},
\code{\link{arrange.TidySet}()},
\code{\link{cartesian}()},
\code{\link{complement_element}()},
\code{\link{complement_set}()},
\code{\link{complement}()},
\code{\link{element_size}()},
\code{\link{elements}()},
\code{\link{filter.TidySet}()},
\code{\link{group_by.TidySet}()},
\code{\link{group}()},
\code{\link{incidence}()},
\code{\link{intersection}()},
\code{\link{is.fuzzy}()},
\code{\link{is_nested}()},
\code{\link{move_to}()},
\code{\link{mutate.TidySet}()},
\code{\link{nElements}()},
\code{\link{nRelations}()},
\code{\link{nSets}()},
\code{\link{name_elements<-}()},
\code{\link{name_sets<-}()},
\code{\link{name_sets}()},
\code{\link{power_set}()},
\code{\link{pull.TidySet}()},
\code{\link{relations}()},
\code{\link{remove_column}()},
\code{\link{remove_element}()},
\code{\link{remove_relation}()},
\code{\link{remove_set}()},
\code{\link{rename_elements}()},
\code{\link{rename_set}()},
\code{\link{select.TidySet}()},
\code{\link{set_size}()},
\code{\link{sets}()},
\code{\link{union}()}
}
\concept{complements}
\concept{methods}
\concept{methods that create new sets}
