% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bubbleplot.R
\name{bubbleplot}
\alias{bubbleplot}
\title{Draws a bubble plot}
\usage{
bubbleplot(
  data,
  id,
  x,
  y,
  col,
  size,
  text.col = NULL,
  text.size = 2.5,
  scale.size = TRUE,
  labels = NULL,
  mx = NULL,
  my = NULL,
  mcol = NULL,
  title = NULL,
  repel = TRUE,
  text.legend = TRUE
)
}
\arguments{
\item{data}{a data frame.}

\item{id}{character, name of the ID variable.}

\item{x}{character, name of the x-axis variable.}

\item{y}{character, name of the y-axis variable.}

\item{col}{character, name of variable on the color axis.}

\item{size}{character, name of variable on the size axis.}

\item{text.col}{character, name of variable for text colors.}

\item{text.size}{integer, text font size.}

\item{scale.size}{logical; if \code{TRUE}, size variable is rescaled between 0 and 100.}

\item{labels}{character vector, variable labels (on legend and axis).}

\item{mx}{numeric, x-coordinate of the vertical axis; default is the mean value of \code{x} variable.}

\item{my}{numeric, y-coordinate of the horizontal axis; default is the mean value of \code{y} variable.}

\item{mcol}{numeric, midpoint of the diverging scale (see \code{\link{scale_colour_gradient2}}); default is the mean value of \code{col} variable.}

\item{title}{character, plot title.}

\item{repel}{logical; if \code{TRUE}, activate text repelling.}

\item{text.legend}{logical; if \code{TRUE}, show the legend for text color.}
}
\value{
A \code{ggplot2} object
}
\description{
Draws a bubble plot
}
\examples{
X <- with(Tbox, data.frame(T=Team, P2p=P2p, P3p=P3p, FTp=FTp, AS=P2A+P3A+FTA))
labs <- c("2-point shots (\% made)","3-point shots (\% made)",
          "free throws (\% made)","Total shots attempted")
bubbleplot(X, id="T", x="P2p", y="P3p", col="FTp",
           size="AS", labels=labs)
}
\references{
P. Zuccolotto and M. Manisera (2020) Basketball Data Science: With Applications in R. CRC Press.
}
\author{
Marco Sandri, Paola Zuccolotto, Marica Manisera (\email{basketballanalyzer.help@unibs.it})
}
