% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.dataset.bins.R
\name{create.data.bins}
\alias{create.data.bins}
\title{New dataset based on bins}
\usage{
create.data.bins(input.obj, bins)
}
\arguments{
\item{input.obj}{an object of class \code{onemap}.}

\item{bins}{an object of class \code{onemap.bin}.}
}
\value{
an object of class \code{onemap}.
}
\description{
Creates a new dataset based on \code{onemap.bin} object
}
\details{
Given a \code{onemap.bin} object,
creates a new data set where the redundant markers are
collapsed into bins and represented by the marker with the lower
amount of missing data among those on the bin.
}
\examples{
 \dontrun{
  load(url("https://github.com/mmollina/data/raw/master/fake_big_data_f2.RData"))
  fake.big.data.f2
  (bins <- find.bins(fake.big.data.f2, exact=FALSE))
  (new.data <- create.data.bins(fake.big.data.f2, bins))}

}
\seealso{
\code{\link[BatchMap]{find.bins}}
}
\author{
Marcelo Mollinari, \email{mmollina@usp.br}
}
\keyword{bins}
\keyword{dimension}
\keyword{reduction}
