\name{CPPpost2mcmc}
\alias{CPPpost2mcmc}
\title{Function to Convert CPP Posterior Samples into MCMC Objects}
\description{A function to convert a CPP posterior sample into an MCMC object,
so that package 'coda' can be used for output diagnostics.}
\usage{CPPpost2mcmc(sampost)}
\arguments{
  \item{sampost}{posterior sample of CPP hazard rates (as generated by \code{\link{CPPpostSample}})}
}
\value{An MCMC object, complete with burn-in and thinning information.}
\note{If package 'coda' is not available, a matrix with meaningful column names is returned.}
\seealso{\code{\link{BayHaz-package}}, \code{\link{CPPpostSample}}}
\examples{
# set RNG seed (for example reproducibility only)
set.seed(1234)

# select a CPP prior distribution
hypars<-CPPpriorElicit(r0 = 0.1, H = 1, T00 = 50, M00 = 2)
# load a data set
data(earthquakes)
# generate a posterior sample
post<-CPPpostSample(hypars, times = earthquakes$ti, obs = earthquakes$ob)

# convert the posterior sample into an MCMC object
MCMCpost<-CPPpost2mcmc(post)
}
\keyword{misc}
