% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun.coda.dic.R
\name{coda.samples.dic}
\alias{coda.samples.dic}
\title{Generate posterior samples in mcmc.list format}
\usage{
coda.samples.dic(model, variable.names, n.iter, thin, ...)
}
\arguments{
\item{model}{a jags model object}

\item{variable.names}{a character vector giving the names of variables
to be monitored}

\item{n.iter}{number of iterations to monitor}

\item{thin}{thinning interval for monitors}

\item{...}{optional arguments that are passed to the \code{jags.samples} method 
from the \code{rjags} library, for jags model objects}
}
\value{
It returns the output to the input model object, and in dic format.
}
\description{
This is a wrapper function for \code{jags.samples} which sets a trace
monitor for all requested nodes, updates the model, and coerces the
output to a single \code{mcmc.list} object. It also converts to the output
to dic format. This function is based on the \code{coda.samples} function
from the \code{rjags} library, and modified by Prof. Matthias Mittner.
}
\references{
\insertRef{plummer2021rjags}{BayesCACE}

\url{https://ihrke.github.io/post/2014/10/07/dicjags/}
}
