% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DetectCpObj.R
\name{summary.DetectCpObj}
\alias{summary.DetectCpObj}
\title{DetectCpObj summary method}
\usage{
\method{summary}{DetectCpObj}(object, ...)
}
\arguments{
\item{object}{an object of class \code{DetectCpObj};}

\item{...}{parameter of the generic method.}
}
\description{
The \code{DetectCpObj} method returns a summary of the algorithm.
}
\examples{

data_mat <- matrix(NA, nrow = 3, ncol = 100)

data_mat[1,] <- as.numeric(c(rnorm(50,0,0.100), rnorm(50,1,0.250)))
data_mat[2,] <- as.numeric(c(rnorm(50,0,0.125), rnorm(50,1,0.225)))
data_mat[3,] <- as.numeric(c(rnorm(50,0,0.175), rnorm(50,1,0.280)))

out <- detect_cp(data = data_mat, n_iterations = 2500, n_burnin = 500,
                params = list(q = 0.25, k_0 = 0.25, nu_0 = 4,
                              S_0 = diag(1,3,3), m_0 = rep(0,3),
                              par_theta_c = 2, par_theta_d = 0.2,
                              prior_var_phi = 0.1), kernel = "ts")
summary(out)

}
