% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ermod.R
\name{plot_er}
\alias{plot_er}
\alias{plot_er.ersim_med_qi}
\alias{plot_er.ersim}
\alias{plot_er.ermod}
\title{Plot ER model simulations}
\usage{
plot_er(x, ...)

\method{plot_er}{ersim_med_qi}(
  x,
  show_orig_data = FALSE,
  show_coef_exp = FALSE,
  show_caption = FALSE,
  options_orig_data = list(),
  options_coef_exp = list(),
  options_caption = list(),
  ...
)

\method{plot_er}{ersim}(
  x,
  show_orig_data = FALSE,
  show_coef_exp = FALSE,
  show_caption = FALSE,
  options_orig_data = list(),
  options_coef_exp = list(),
  options_caption = list(),
  qi_width_sim = 0.95,
  ...
)

\method{plot_er}{ermod}(
  x,
  show_orig_data = FALSE,
  show_coef_exp = FALSE,
  show_caption = FALSE,
  options_orig_data = list(),
  options_coef_exp = list(),
  options_caption = list(),
  n_draws_sim = if (marginal) 200 else NULL,
  seed_sample_draws = NULL,
  marginal = FALSE,
  exposure_range = NULL,
  num_exposures = 51,
  qi_width_sim = 0.95,
  ...
)
}
\arguments{
\item{x}{an object of class \code{ermod}, \code{ersim},\code{ersim_med_qi},
or their subclasses}

\item{...}{currently not used}

\item{show_orig_data}{logical, whether to show the data points in the
model development dataset. Default is \code{FALSE}. Only support plotting
with data that was used in the model development. If you want to use
other data, consider adding geom_point() to the plot manually.}

\item{show_coef_exp}{logical, whether to show the credible interval
of the exposure coefficient. Default is \code{FALSE}. This is only available
for linear and linear logistic regression models.}

\item{show_caption}{logical, whether to show the caption note for the plot.
Default is \code{FALSE}.}

\item{options_orig_data}{List of options for configuring how original data
is displayed. Possible options include:
\itemize{
\item \code{add_boxplot}: Logical, whether to add a boxplot of exposure values.
Default is \code{FALSE}.
\item \code{boxplot_height}: Height of the boxplot relative to the main plot.
Default is \code{0.15}.
\item \code{show_boxplot_y_title}: Logical, whether to show the y-axis title
for the boxplot. Default is \code{TRUE}.
\item \code{var_group}: The column to use for grouping data for plotting.
If specified, observed data points and boxplot will be grouped
and colored by this column. Default is \code{NULL}.
\item \code{n_bins}: Number of bins to use for observed probability
summary. Only relevant for binary models. Default is \code{4}.
\item \code{qi_width}: Width of the quantile interval (confidence interval) for
the observed probability summary. Only relevant for binary models.
Default is \code{0.95}.
}}

\item{options_coef_exp}{List of options for configuring how the exposure
coefficient credible interval is displayed. Possible options include:
\itemize{
\item \code{qi_width}: Width of the quantile interval (credible interval) for
the exposure coefficient. Default is \code{0.95}.
\item \code{n_sigfig}: Number of significant figures to display. Default is \code{3}.
\item \code{pos_x}: x-coordinate of the text label. If \code{NULL} (default), it is
set to the minimum value for the exposure variable.
\item \code{pos_y}: y-coordinate of the text label. If \code{NULL} (default), it is
set to 0.9 for logistic regression models and the maximum value of the
response variable in the original data for linear regression models.
\item \code{size}: Size of the text label. Default is \code{4}.
}}

\item{options_caption}{List of options for configuring the caption note.
Possible options include:
\itemize{
\item \code{orig_data}: Logical, whether to show the caption note for the
observed data. Default is \code{FALSE}.
\item \code{orig_data_summary}: Logical, whether to show the caption note for the
observed data summary. Default is \code{FALSE}.
Only relevant for binary models.
\item \code{coef_exp}: Logical, whether to show the caption note for the
exposure coefficient credible interval. Default is \code{FALSE}.
}}

\item{qi_width_sim}{Width of the quantile interval to summarize simulated
draws.}

\item{n_draws_sim}{Number of draws to simulate response for each exposure
value. Set to NULL to use all draws in the model object. Default is NULL
unless marginal is set to TRUE (in that case 200 by default to reduce
computation time).}

\item{seed_sample_draws}{Seed for sampling draws. Default is NULL.}

\item{marginal}{logical, whether to use marginal ER simulation. Default
to \code{FALSE}. Need to set to \code{TRUE} if the model has covariates for the
plot to work.}

\item{exposure_range}{Only relevant when the input x is an \code{ermod} object.
Range of exposure values to simulate. If NULL
(default), it is set to the range of the exposure variable in the original
data for model development.}

\item{num_exposures}{Only relevant as with \code{exposure_range}.
Number of exposure values to simulate.}
}
\value{
A ggplot object
}
\description{
Plot ER model simulations
}
\details{
Plotting with \code{ermod} is done with some default values. If they are not
suitable, you can always perform the simulation manually and use
\code{plot_er()} on the simulated data.
}
\examples{
\dontshow{if (BayesERtools:::.if_run_ex_plot_er()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
data(d_sim_binom_cov_hgly2)

ermod_bin <- dev_ermod_bin(
  data = d_sim_binom_cov_hgly2,
  var_resp = "AEFLAG",
  var_exposure = "AUCss_1000"
)

ersim_med_qi <- sim_er_curve(
  ermod_bin,
  output_type = "median_qi"
)

plot_er(ersim_med_qi, show_orig_data = TRUE) +
  # Use log10 scale for exposure
  xgxr::xgx_scale_x_log10(guide = ggplot2::guide_axis(minor.ticks = TRUE))
}
\dontshow{\}) # examplesIf}
}
